<?php $__env->startSection('content'); ?>
<div class="row">
   <div class="col-lg-12">
      <div class="card">
         <div class="card-header">
            <span class="panel-title"><?php echo e(_lang("View Loan Details")); ?></span>
         </div>
         <div class="card-body">
            <!-- Nav tabs -->
            <ul class="nav nav-tabs">
               <li class="nav-item">
                  <a class="nav-link active" data-toggle="tab" href="#loan_details"><?php echo e(_lang("Loan Details")); ?></a>
               </li>
               <li class="nav-item">
                  <a class="nav-link" data-toggle="tab" href="#collateral"><?php echo e(_lang("Collateral")); ?></a>
               </li>
               <li class="nav-item">
                  <a class="nav-link" data-toggle="tab" href="#schedule"><?php echo e(_lang("Repayments Schedule")); ?></a>
               </li>
               <li class="nav-item">
                  <a class="nav-link" data-toggle="tab" href="#repayments"><?php echo e(_lang("Repayments")); ?></a>
               </li>
               <li class="nav-item">
                  <a
                     class="nav-link"
                     href="<?php echo e(action('LoanController@edit', $loan['id'])); ?>"
                     ><?php echo e(_lang("Edit")); ?></a
                     >
               </li>
            </ul>
            <!-- Tab panes -->
            <div class="tab-content">
               <div class="tab-pane active" id="loan_details">
                  <?php if($loan->status == 0): ?>
                  <div class="alert alert-warning mt-4">
                     <p>
                        <?php echo e(_lang("Add Loan ID, Release Date and First Payment Date before approving loan request")); ?>

                     </p>
                  </div>
                  <?php endif; ?>
                  <table class="table table-bordered mt-4">
                     <tr>
                        <td><?php echo e(_lang("Loan ID")); ?></td>
                        <td><?php echo e($loan->loan_id); ?></td>
                     </tr>
                     <tr>
                        <td><?php echo e(_lang("Borrower")); ?></td>
                        <td><?php echo e($loan->borrower->name); ?></td>
                     </tr>
                     <tr>
                        <td><?php echo e(_lang("Account")); ?></td>
                        <td><?php echo e($loan->borrower->email); ?></td>
                     </tr>
                     <tr>
                        <td><?php echo e(_lang("Status")); ?></td>
                        <td>
                            <?php if($loan->status == 0): ?>
                                <?php echo xss_clean(show_status(_lang('Pending'), 'warning')); ?>

                            <?php elseif($loan->status == 1): ?>
                                <?php echo xss_clean(show_status(_lang('Approved'), 'success')); ?>

                            <?php elseif($loan->status == 2): ?>
                                <?php echo xss_clean(show_status(_lang('Completed'), 'info')); ?>

                            <?php elseif($loan->status == 3): ?>
                                <?php echo xss_clean(show_status(_lang('Cancelled'), 'danger')); ?>

                            <?php endif; ?>

                           <?php if($loan->status == 0): ?>
                           <a class="btn btn-outline-primary btn-sm" href="<?php echo e(action('LoanController@approve', $loan['id'])); ?>"><i class="icofont-check-circled"></i> <?php echo e(_lang("Click to Approve")); ?></a
                              >
                           <a class="btn btn-outline-danger btn-sm float-right" href="<?php echo e(action('LoanController@reject', $loan['id'])); ?>"><i class="icofont-close-line-circled"></i> <?php echo e(_lang("Click to Reject")); ?></a>
                           <?php endif; ?>
                        </td>
                     </tr>
                     <tr>
                        <td><?php echo e(_lang("First Payment Date")); ?></td>
                        <td><?php echo e($loan->first_payment_date); ?></td>
                     </tr>
                     <tr>
                        <td><?php echo e(_lang("Release Date")); ?></td>
                        <td>
                           <?php echo e($loan->release_date != '' ? $loan->release_date : ''); ?>

                        </td>
                     </tr>
                     <tr>
                        <td><?php echo e(_lang("Applied Amount")); ?></td>
                        <td>
                           <?php echo e(decimalPlace($loan->applied_amount, currency($loan->currency->name))); ?>

                        </td>
                     </tr>
                     <tr>
                        <td><?php echo e(_lang("Total Principle Paid")); ?></td>
                        <td class="text-success">
                           <?php echo e(decimalPlace($loan->total_paid, currency($loan->currency->name))); ?>

                        </td>
                     </tr>
                     <tr>
                        <td><?php echo e(_lang("Total Interest Paid")); ?></td>
                        <td class="text-success">
                           <?php echo e(decimalPlace($loan->payments->sum('interest'), currency($loan->currency->name))); ?>

                        </td>
                     </tr>
                     <tr>
                        <td><?php echo e(_lang("Total Penalties Paid")); ?></td>
                        <td class="text-success">
                           <?php echo e(decimalPlace($loan->payments->sum('late_penalties'), currency($loan->currency->name))); ?>

                        </td>
                     </tr>
                     <tr>
                        <td><?php echo e(_lang("Due Amount")); ?></td>
                        <td class="text-danger">
                           <?php echo e(decimalPlace($loan->applied_amount - $loan->total_paid, currency($loan->currency->name))); ?>

                        </td>
                     </tr>
                     <tr>
                        <td><?php echo e(_lang("Late Payment Penalties")); ?></td>
                        <td><?php echo e($loan->late_payment_penalties); ?> %</td>
                     </tr>
                     <tr>
                        <td><?php echo e(_lang("Attachment")); ?></td>
                        <td>
                           <?php echo $loan->attachment == "" ? '' : '<a
                              href="'. asset('public/uploads/media/'.$loan->attachment) .'"
                              target="_blank"
                              >'._lang('Download').'</a
                              >'; ?>

                        </td>
                     </tr>
                     <?php if($loan->status == 1): ?>
                     <tr>
                        <td><?php echo e(_lang("Approved Date")); ?></td>
                        <td><?php echo e($loan->approved_date); ?></td>
                     </tr>
                     <tr>
                        <td><?php echo e(_lang("Approved By")); ?></td>
                        <td><?php echo e($loan->approved_by->name); ?></td>
                     </tr>
                     <?php endif; ?>
                     <tr>
                        <td><?php echo e(_lang("Description")); ?></td>
                        <td><?php echo e($loan->description); ?></td>
                     </tr>
                     <tr>
                        <td><?php echo e(_lang("Remarks")); ?></td>
                        <td><?php echo e($loan->remarks); ?></td>
                     </tr>
                  </table>
               </div>
               <div class="tab-pane fade" id="collateral">
                  <div class="card">
                     <div class="card-header d-flex align-items-center">
                        <span><?php echo e(_lang("All Collaterals")); ?></span>
                        <a
                           class="btn btn-primary btn-sm ml-auto"
                           href="<?php echo e(route('loan_collaterals.create',['loan_id' => $loan->id])); ?>"
                           ><i class="icofont-plus-circle"></i>
                        <?php echo e(_lang("Add New Collateral")); ?></a
                           >
                     </div>
                     <div class="card-body">
                        <div class="table-responsive">
                           <table class="table table-bordered mt-2">
                              <thead>
                                 <tr>
                                    <th><?php echo e(_lang("Name")); ?></th>
                                    <th><?php echo e(_lang("Collateral Type")); ?></th>
                                    <th><?php echo e(_lang("Serial Number")); ?></th>
                                    <th><?php echo e(_lang("Estimated Price")); ?></th>
                                    <th class="text-center"><?php echo e(_lang("Action")); ?></th>
                                 </tr>
                              </thead>
                              <tbody>
                                 <?php $__currentLoopData = $loancollaterals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loancollateral): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                 <tr data-id="row_<?php echo e($loancollateral->id); ?>">
                                    <td class="name"><?php echo e($loancollateral->name); ?></td>
                                    <td class="collateral_type">
                                       <?php echo e($loancollateral->collateral_type); ?>

                                    </td>
                                    <td class="serial_number">
                                       <?php echo e($loancollateral->serial_number); ?>

                                    </td>
                                    <td class="estimated_price">
                                       <?php echo e(decimalPlace($loancollateral->estimated_price, currency($loan->currency->name))); ?>

                                    </td>
                                    <td class="text-center">
                                       <div class="dropdown">
                                          <button
                                             class="btn btn-primary dropdown-toggle btn-sm"
                                             type="button"
                                             id="dropdownMenuButton"
                                             data-toggle="dropdown"
                                             aria-haspopup="true"
                                             aria-expanded="false"
                                             >
                                          <?php echo e(_lang("Action")); ?>

                                          </button>
                                          <form
                                             action="<?php echo e(action(
                                             'LoanCollateralController@destroy',
                                             $loancollateral['id']
                                             )); ?>"
                                             method="post"
                                             >
                                             <?php echo e(csrf_field()); ?>

                                             <input
                                                name="_method"
                                                type="hidden"
                                                value="DELETE"
                                                />
                                             <div
                                                class="dropdown-menu"
                                                aria-labelledby="dropdownMenuButton"
                                                >
                                                <a
                                                   href="<?php echo e(action(
                                                   'LoanCollateralController@edit',
                                                   $loancollateral['id']
                                                   )); ?>"
                                                   class="
                                                   dropdown-item dropdown-edit dropdown-edit
                                                   "
                                                   ><i class="icofont-ui-edit"></i>
                                                <?php echo e(_lang("Edit")); ?></a
                                                   >
                                                <a
                                                   href="<?php echo e(action(
                                                   'LoanCollateralController@show',
                                                   $loancollateral['id']
                                                   )); ?>"
                                                   class="
                                                   dropdown-item dropdown-view dropdown-view
                                                   "
                                                   ><i class="icofont-eye-alt"></i>
                                                <?php echo e(_lang("View")); ?></a
                                                   >
                                                <button
                                                   class="btn-remove dropdown-item"
                                                   type="submit"
                                                   >
                                                <i class="icofont-trash"></i>
                                                <?php echo e(_lang("Delete")); ?>

                                                </button>
                                             </div>
                                          </form>
                                       </div>
                                    </td>
                                 </tr>
                                 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                              </tbody>
                           </table>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="tab-pane fade mt-4" id="schedule">
                  <table class="table table-bordered data-table">
                     <thead>
                        <tr>
                           <th><?php echo e(_lang("Date")); ?></th>
                           <th class="text-right"><?php echo e(_lang("Amount to Pay")); ?></th>
                           <th class="text-right"><?php echo e(_lang("Penalty")); ?></th>
                           <th class="text-right"><?php echo e(_lang("Principal Amount")); ?></th>
                           <th class="text-right"><?php echo e(_lang("Interest")); ?></th>
                           <th class="text-right"><?php echo e(_lang("Balance")); ?></th>
                           <th class="text-center"><?php echo e(_lang("Status")); ?></th>
                        </tr>
                     </thead>
                     <tbody>
                        <?php $__currentLoopData = $repayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $repayment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                           <td><?php echo e($repayment->repayment_date); ?></td>
                           <td class="text-right">
                              <?php echo e(decimalPlace($repayment['amount_to_pay'], currency($loan->currency->name))); ?>

                           </td>
                           <td class="text-right">
                              <?php echo e(decimalPlace($repayment['penalty'], currency($loan->currency->name))); ?>

                           </td>
                           <td class="text-right">
                              <?php echo e(decimalPlace($repayment['principal_amount'], currency($loan->currency->name))); ?>

                           </td>
                           <td class="text-right">
                              <?php echo e(decimalPlace($repayment['interest'], currency($loan->currency->name))); ?>

                           </td>
                           <td class="text-right">
                              <?php echo e(decimalPlace($repayment['balance'], currency($loan->currency->name))); ?>

                           </td>
                           <td class="text-center">
                              <?php echo $repayment['status'] == 1 ?
                              show_status(_lang('Paid'),'success') :
                              show_status(_lang('Unpaid'),'danger'); ?>

                           </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                     </tbody>
                  </table>
               </div>
               <div class="tab-pane fade mt-4" id="repayments">
                  <table class="table table-bordered data-table">
                     <thead>
                        <tr>
                           <th><?php echo e(_lang("Date")); ?></th>
                           <th class="text-right"><?php echo e(_lang("Principal Amount")); ?></th>
                           <th class="text-right"><?php echo e(_lang("Interest")); ?></th>
                           <th class="text-right"><?php echo e(_lang("Late Penalty")); ?></th>
                           <th class="text-right"><?php echo e(_lang("Total Amount")); ?></th>
                        </tr>
                     </thead>
                     <tbody>
                        <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                           <td><?php echo e($payment->paid_at); ?></td>
                           <td class="text-right">
                              <?php echo e(decimalPlace($payment['amount_to_pay'] - $payment['interest'], currency($loan->currency->name))); ?>

                           </td>
                           <td class="text-right">
                              <?php echo e(decimalPlace($payment['interest'], currency($loan->currency->name))); ?>

                           </td>
                           <td class="text-right">
                              <?php echo e(decimalPlace($payment['late_penalties'], currency($loan->currency->name))); ?>

                           </td>
                           <td class="text-right">
                              <?php echo e(decimalPlace($payment['amount_to_pay'] + $payment['late_penalties'], currency($loan->currency->name))); ?>

                           </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                     </tbody>
                  </table>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
   (function($) {
       "use strict";

   	$('.nav-tabs a').on('shown.bs.tab', function(event){
   		var tab = $(event.target).attr("href");
   		var url = "<?php echo e(route('loans.show',$loan->id)); ?>";
   	    history.pushState({}, null, url + "?tab=" + tab.substring(1));
   	});

   	<?php if(isset($_GET['tab'])): ?>
   	   $('.nav-tabs a[href="#<?php echo e($_GET['tab']); ?>"]').tab('show');
   	<?php endif; ?>

   })(jQuery);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u870896357/domains/fedus.afarmart.com/public_html/resources/views/backend/loan/view.blade.php ENDPATH**/ ?>