<?php $__env->startSection('content'); ?>
<div class="auth-container d-md-flex align-items-center">
    <div class="container">
        <div class="row">
            <div class="col-md-12 col-lg-10 offset-lg-1">
                <div class="bg-white p-2">
                    <div class="row no-gutters">
                        <div class="col-md-6">
                            <div class="card card-signin p-3">
                                <div class="card-body">
                                    <img class="logo" src="<?php echo e(get_logo()); ?>">

                                    <h6 class="py-4"><?php echo e(_lang('Login To Your Account')); ?></h6>

                                    <?php if(Session::has('error')): ?>
                                        <div class="alert alert-danger text-center">
                                            <strong><?php echo e(session('error')); ?></strong>
                                        </div>
                                    <?php endif; ?>

                                    <?php if(Session::has('registration_success')): ?>
                                        <div class="alert alert-success text-center">
                                            <strong><?php echo e(session('registration_success')); ?></strong>
                                        </div>
                                    <?php endif; ?>

                                    <form method="POST" class="form-signin" action="<?php echo e(route('login')); ?>">
                                        <?php echo csrf_field(); ?>

                                        <div class="form-group row">
                                            <div class="col-md-12">
                                                <input id="email" type="email" class="form-control<?php echo e($errors->has('email') ? ' is-invalid' : ''); ?>" name="email" value="<?php echo e(old('email')); ?>" placeholder="<?php echo e(_lang('Email')); ?>" required autofocus>

                                                <?php if($errors->has('email')): ?>
                                                    <span class="invalid-feedback">
                                                        <strong><?php echo e($errors->first('email')); ?></strong>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <div class="col-md-12">

                                                <input id="password" type="password" class="form-control<?php echo e($errors->has('password') ? ' is-invalid' : ''); ?>" name="password" placeholder="<?php echo e(_lang('Password')); ?>" required>

                                                <?php if($errors->has('password')): ?>
                                                    <span class="invalid-feedback">
                                                        <strong><?php echo e($errors->first('password')); ?></strong>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <div class="col-md-12">
                                                <input type="hidden" name="g-recaptcha-response" id="recaptcha">
                                                <?php if($errors->has('g-recaptcha-response')): ?>
                                                    <span class="invalid-feedback">
                                                        <strong><?php echo e($errors->first('g-recaptcha-response')); ?></strong>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <div class="col-md-12">
                                                <div class="custom-control custom-checkbox mb-2">
                                                    <input type="checkbox" name="remember" class="custom-control-input" id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                                    <label class="custom-control-label" for="remember"><?php echo e(_lang('Remember Me')); ?></label>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group row mb-0">
                                            <div class="col-md-12">

                                                <button type="submit" class="btn btn-login btn-block">
                                                    <?php echo e(_lang('Login')); ?>

                                                </button>

                                                <?php if(get_option('allow_singup') == 'yes'): ?>
                                                <a class="btn btn-register btn-block" href="<?php echo e(route('register')); ?>">
                                                    <?php echo e(_lang('Create Your Account')); ?>

                                                </a>
                                                <?php endif; ?>

                                                <?php if(get_option('google_login') == 'enabled'): ?>
                                                    <a href="<?php echo e(url('/login/google')); ?>" class="btn btn-google btn-block"> <?php echo e(_lang('Continue With Google')); ?></a>
                                                <?php endif; ?>

                                                <?php if(get_option('facebook_login') == 'enabled'): ?>
                                                    <a href="<?php echo e(url('/login/facebook')); ?>" class="btn btn-facebook btn-block"> <?php echo e(_lang('Continue With Facebook')); ?></a>
                                                <?php endif; ?>

                                            </div>
                                        </div>


                                        <div class="form-group row mt-3">
                                            <div class="col-md-12 text-center">
                                                <a class="btn-link" href="<?php echo e(route('password.request')); ?>">
                                                    <?php echo e(_lang('Forgot Password?')); ?>

                                                </a>
                                            </div>
                                        </div>
                                    </form>

                                    <div class="footer-links text-center">
                                        <?php if(get_option('website_enable', 'yes') == 'yes'): ?>
                                        <a href="<?php echo e(url('/' . get_option('privacy_policy_page'))); ?>" target="_blank"><?php echo e(_lang('Privacy Policy')); ?></a>
                                        &nbsp;
                                        <a href="<?php echo e(url('/' . get_option('terms_condition_page'))); ?>" target="_blank"><?php echo e(_lang('Terms & Condition')); ?></a>
                                        <?php else: ?>
                                        <a href="<?php echo e(get_option('privacy_policy_page_url')); ?>" target="_blank"><?php echo e(_lang('Privacy Policy')); ?></a>
                                        &nbsp;
                                        <a href="<?php echo e(get_option('terms_condition_page_url')); ?>" target="_blank"><?php echo e(_lang('Terms & Condition')); ?></a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 d-none d-md-block">
                            <div id="auth-bg" class="d-flex align-items-center justify-content-center">
                                <div class="px-5">
                                    <p class="mb-1 font-weight-light"><?php echo e(_lang('WELCOME TO')); ?></p>
                                    <h2 class="font-weight-bold"><?php echo e(get_option('site_title', config('app.name'))); ?></h2>

                                    <div class="divider"></div>

                                    <p><?php echo e(_lang('Enter your registered email and password and login into your account')); ?></p>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if(get_option('enable_recaptcha', 0) == 1): ?>
<script src="https://www.google.com/recaptcha/api.js?render=<?php echo e(get_option('recaptcha_site_key')); ?>"></script>
<script>
    grecaptcha.ready(function() {
        grecaptcha.execute('<?php echo e(get_option('recaptcha_site_key')); ?>', {action: 'login'}).then(function(token) {
        if (token) {
            document.getElementById('recaptcha').value = token;
        }
        });
    });
</script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u870896357/domains/fedus.afarmart.com/public_html/resources/views/auth/login.blade.php ENDPATH**/ ?>