<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-8 offset-lg-2">
		<div class="card">
			<div class="card-header">
				<h4 class="header-title text-center"><?php echo e(_lang('Exchange Money')); ?></h4>
			</div>
			<div class="card-body">
			    <form method="post" class="validate" autocomplete="off" action="<?php echo e(route('transfer.exchange_money')); ?>" enctype="multipart/form-data">
					<?php echo e(csrf_field()); ?>


					<div class="row">
						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Exchange From')); ?></label>
								<select class="form-control auto-select select2" data-selected="<?php echo e(old('currency_from')); ?>" name="currency_from" id="currency_from" required>
									<option value=""><?php echo e(_lang('Select One')); ?></option>
									<?php echo e(create_option('currency','id','name','',array('status=' => 1))); ?>

								</select>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Exchange To')); ?></label>
								<select class="form-control auto-select select2" data-selected="<?php echo e(old('currency_to')); ?>" name="currency_to" id="currency_to" required>
									<option value=""><?php echo e(_lang('Select One')); ?></option>
									<?php echo e(create_option('currency','id','name','',array('status=' => 1))); ?>

								</select>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Amount')); ?></label>
								<input type="text" class="form-control float-field" name="amount" id="amount" value="<?php echo e(old('amount')); ?>" required>
							</div>
						</div>

						<div class="col-lg-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Exchanged Amount')); ?></label>
								<input type="text" class="form-control float-field" id="exchange_amount" value="" readonly>
							</div>
						</div>

						<div class="col-md-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Note')); ?></label>
								<textarea class="form-control" name="note"><?php echo e(old('note')); ?></textarea>
							</div>
						</div>

						<div class="col-md-12">
							<h6 class="text-info text-center"><b><?php echo e(get_option('exchange_fee_type') == 'percentage' ? get_option('exchange_fee').'%' : currency().get_option('exchange_fee')); ?> <?php echo e(_lang('exchange fee will apply')); ?></b></h6>
						</div>

						<div class="col-md-12 mt-4">
							<div class="form-group">
								<button type="submit" class="btn btn-primary btn-lg btn-block"><i class="icofont-check-circled"></i> <?php echo e(_lang('Exchange Money')); ?></button>
							</div>
						</div>
					</div>
			    </form>
			</div>
		</div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
(function ($) {
  "use strict";

  $(document).on('change','#currency_from, #currency_to', function(){
	$("#amount").val('');
	$("#exchange_amount").val('');
  });

  $(document).on('keyup','#amount', function(){
	  	var from = $("#currency_from").val();
	  	var to = $("#currency_to").val();
	  	var amount = $(this).val();

		if(from == '' || to == '' ){
			Swal.fire(
				'<?php echo e(_lang('Alert')); ?>',
				'<?php echo e(_lang('Please select exchange from and exchange to !')); ?>',
				'warning'
			);
			$(this).val('');
			return;
		}

		if(amount != ''){
			$.ajax({
				url: '<?php echo e(route('transfer.get_exchange_amount')); ?>/' + from + '/' + to + '/' + amount,
				beforeSend: function(){
					$("#submit-btn").prop('disabled', true);
				},success: function(data){
					var json = JSON.parse(JSON.stringify(data));
					$("#exchange_amount").val(json['amount'].toFixed(2));
					$("#submit-btn").prop('disabled', false);
				}
			});
		}else{
			$("#exchange_amount").val('');
		}
	
  });

})(jQuery);
</script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u870896357/domains/fedus.afarmart.com/public_html/resources/views/backend/customer_portal/exchange_money.blade.php ENDPATH**/ ?>