<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col-lg-8 offset-lg-2">
		<div class="card">
			<div class="card-header">
				<h4 class="header-title text-center"><?php echo e(_lang('Wire Transfer')); ?></h4>
			</div>
			<div class="card-body">
			    <form method="post" class="validate" autocomplete="off" action="<?php echo e(route('transfer.wire_transfer')); ?>" enctype="multipart/form-data">
					<?php echo e(csrf_field()); ?>

					<div class="row">
						<?php if(get_option('bank_selection_method','selectbox') == 'selectbox'): ?>
						<div class="col-md-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Bank')); ?></label>
								<select class="form-control auto-select select2" data-selected="<?php echo e(old('bank')); ?>" name="bank" id="bank" required>
									<option value=""><?php echo e(_lang('Select One')); ?></option>
									<?php $__currentLoopData = \App\Models\OtherBank::where('status',1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($bank->id); ?>"><?php echo e($bank->name); ?></option>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</select>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Swift Code')); ?></label>
								<input type="text" class="form-control" id="swift_code" readonly>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Currency')); ?></label>
								<input type="text" class="form-control" id="currency" readonly>
							</div>
						</div>
						<?php else: ?>
						<div class="col-md-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Bank Name')); ?></label>
								<input type="text" class="form-control" id="bank_name" name="td[bank_name]" value="<?php echo e(old('td.bank_name')); ?>" required>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Country')); ?></label>
								<select class="form-control select2 auto-select" name="td[country]" data-selected="<?php echo e(old('td.country')); ?>" required>
									<option value=""><?php echo e(_lang('Select One')); ?></option>
									<?php echo e(get_country_list()); ?>

								</select>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Swift Code')); ?></label>
								<input type="text" class="form-control" id="swift_code" name="td[swift_code]" value="<?php echo e(old('td.swift_code')); ?>" required>
							</div>
						</div>
						<?php endif; ?>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Account Number')); ?></label>
								<input type="text" class="form-control" name="td[account_number]" value="<?php echo e(old('td.account_number')); ?>" required>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Account Holder Name')); ?></label>
								<input type="text" class="form-control" name="td[account_holder_name]" value="<?php echo e(old('td.account_holder_name')); ?>" required>
							</div>
						</div>

						<?php if(get_option('bank_selection_method','selectbox') == 'selectbox'): ?>
						<div class="col-md-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Amount')); ?></label>
								<input type="text" class="form-control float-field" name="amount" value="<?php echo e(old('amount')); ?>" required>
								<small id="amount_limit"></small>
								<p class="text-info" id="fee"></p>
							</div>
						</div>
						<?php else: ?>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Currency')); ?></label>
								<select class="form-control select2 auto-select" name="td[currency]" data-selected="<?php echo e(old('td.currency')); ?>" required>
									<option value=""><?php echo e(_lang('Select One')); ?></option>
									<?php echo e(create_option('currency','id','name','',array('status=' => 1))); ?>

								</select>
							</div>
						</div>

						<div class="col-md-6">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Amount')); ?></label>
								<input type="text" class="form-control float-field" name="amount" value="<?php echo e(old('amount')); ?>" required>
								<small id="amount_limit"></small>
								<p class="text-info" id="fee"></p>
							</div>
						</div>
						<?php endif; ?>

						<div class="col-md-12">
							<div class="form-group">
								<label class="control-label"><?php echo e(_lang('Note')); ?></label>
								<textarea class="form-control" name="note"><?php echo e(old('note')); ?></textarea>
							</div>
						</div>

						<div class="col-md-12">
							<h6 id="instructions"></h6>
						</div>

						<div class="col-md-12 mt-4">
							<div class="form-group">
								<button type="submit" class="btn btn-primary btn-lg btn-block"><i class="icofont-check-circled"></i> <?php echo e(_lang('Submit')); ?></button>
							</div>
						</div>
					</div>
			    </form>
			</div>
		</div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
(function ($) {
  "use strict";
	$(document).on('change','#bank',function(){
		if($(this).val() != ''){
			$.ajax({
				url: "<?php echo e(route('transfer.get_other_bank_details')); ?>" + "/" + $(this).val(),
				success: function(data){
					var currency = data['currency']['name'];
					$("#swift_code").val(data['swift_code']);
					$("#currency").val(currency);
					$("#instructions").html(data['descriptions']);
					$("#fee").html("<?php echo e(_lang('Transaction Fee')); ?> " + currency +' '+ data['fixed_charge'] + " + " + data['charge_in_percentage'] + "%");
					$("#amount_limit").text("<?php echo e(_lang('Transfer Limit')); ?> (" + currency + " " + data['minimum_transfer_amount'] + " - " + currency + " " + data['maximum_transfer_amount'] + ")");
				}
			})
		}
	});
})(jQuery);
</script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u870896357/domains/fedus.afarmart.com/public_html/resources/views/backend/customer_portal/wire_transfer.blade.php ENDPATH**/ ?>