<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e(get_option('site_title', config('app.name'))); ?></title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>"/>

    <!-- App favicon -->
    <link rel="shortcut icon" href="<?php echo e(get_favicon()); ?>"/>

    <!-- Google font -->
	<link rel="preconnect" href="https://fonts.gstatic.com">
	<link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@300;400;600;700&display=swap" rel="stylesheet">

    <!-- Styles -->
    <link href="<?php echo e(asset('public/auth/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('public/auth/css/app.css?v=1.2')); ?>" rel="stylesheet">

    <!--- Custom CSS Code --->
    <style type="text/css">
        <?php $bgColor = get_option('auth_bg_color_2','#0b2559'); ?>
        .area{
            background: <?php echo e($bgColor); ?>;
            background: -webkit-linear-gradient(to left, <?php echo e(get_option('auth_bg_color_1','#26437e')); ?>, <?php echo e(get_option('auth_bg_color_2','#0b2559')); ?>);
            background: linear-gradient(to left, <?php echo e(get_option('auth_bg_color_1','#26437e')); ?>, <?php echo e(get_option('auth_bg_color_2','#0b2559')); ?>);
        }
        <?php $bgImage = get_option('auth_bg_image') == '' ? asset('public/auth/images/auth-bg.jpg') : asset('public/uploads/media/'.get_option('auth_bg_image')); ?>
        #auth-bg{background: url(<?php echo e($bgImage); ?>) no-repeat;}

        #auth-bg::after {background: <?php echo e(hex2rgba($bgColor, 0.9)); ?>;}
    </style>
</head>
<body>
    <div class="area" >
        <ul class="circles">
            <li></li>
            <li></li>
            <li></li>
            <li></li>
            <li></li>
            <li></li>
            <li></li>
            <li></li>
            <li></li>
            <li></li>
        </ul>
    </div>

    <div id="app">
        <main class="py-4">
            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>

	<?php echo $__env->yieldContent('js-script'); ?>
</body>
</html>
<?php /**PATH /home/coinsinv/public_html/us.rostcu-online.com/resources/views/layouts/auth.blade.php ENDPATH**/ ?>