@extends('theme.layout')


@section('content')
<!-- Slider Start -->

	<?php
include '/home/coinsinv/public_html/us.rostcu-online.com/resources/views/theme/test.php'
?>
<section class="banner d-flex align-items-center" style="background: url({{ get_option('home_banner') == '' ? asset('public/theme/images/slider-bg-1.jpg') : media_images(get_option('home_banner')) }})">
	<div class="container">
		<div class="row">
			<div class="col-lg-8">
				<div class="block">
					<h1 class="mb-3">{{ get_trans_option('main_heading') }}</h1>

					<p class="mb-4 pr-5 text-white">{{ get_trans_option('sub_heading') }}</p>
					<div class="btn-container">
						<a href="{{ get_option('allow_singup') == 'yes' ? route('register') : route('login') }}" class="btn btn-main-2">{{ _lang('Get Started') }} <i class="icofont-simple-right ml-2"></i></a>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<section class="section about">
	<div class="container">
		<div class="row align-items-center">
	
		    
		    
		    
			<div class="col-lg-6">
				<div class="about-img">
					<img src="{{ get_option('home_about_us_banner') == '' ? asset('public/theme/images/about-us.jpg') : media_images(get_option('home_about_us_banner')) }}" alt="" class="img-fluid">
				</div>
			</div>
			<div class="col-lg-6">
				<div class="about-content pl-4 mt-4 mt-lg-0">
					<h2 class="title-color">{{ get_trans_option('home_about_us_heading') }}</h2>
					<p class="mt-4 mb-5">{{ get_trans_option('home_about_us_content') }}</p>

					<a href="{{ get_option('home_about_us_link') }}" class="btn btn-main-2 btn-icon">{{ get_trans_option('home_about_us_button','Services') }}<i class="icofont-simple-right ml-3"></i></a>
				</div>
			</div>
		</div>
	</div>
</section>
<section class="cta-section">
	<div class="container">
		<div class="cta position-relative">
			<div class="row">
				<div class="col-lg-3 col-md-6 col-sm-6">
					<div class="counter-stat">
						<i class="icofont-doctor"></i>
						<span class="h3">{{ get_option('total_customer',0) }}</span>+
						<p>{{ _lang('Customers') }}</p>
					</div>
				</div>
				<div class="col-lg-3 col-md-6 col-sm-6">
					<div class="counter-stat">
						<i class="icofont-flag"></i>
						<span class="h3">{{ get_option('total_branch',0) }}</span>
						<p>{{ _lang('Branches') }}</p>
					</div>
				</div>

				<div class="col-lg-3 col-md-6 col-sm-6">
					<div class="counter-stat">
						<i class="icofont-credit-card"></i>
						<span class="h3">{{ get_option('total_transactions',0) }}</span>M
						<p>{{ _lang('Total Transactions') }}</p>
					</div>
				</div>
				<div class="col-lg-3 col-md-6 col-sm-6">
					<div class="counter-stat">
						<i class="icofont-globe"></i>
						<span class="h3">{{ get_option('total_countries',0) }}</span>+
						<p>{{ _lang('Supported Country') }}</p>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<section class="section service gray-bg">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-lg-7 text-center">
				<div class="section-title">
					<h2>{{ get_trans_option('home_service_heading') }}</h2>
					<div class="divider mx-auto my-4"></div>
					<p>{{ get_trans_option('home_service_content') }}</p>
				</div>
			</div>
		</div>

		<div class="row">
		@foreach($services as $service)
			<div class="col-lg-4 col-md-6">
				<div class="service-item mb-4">
					<div class="icon d-flex align-items-center">
						{!! xss_clean($service->icon) !!}
						<h4 class="mt-3 mb-3">{{ $service->translation->title }}</h4>
					</div>

					<div class="content">
						<p class="mb-4">{{ $service->translation->body }}</p>
					</div>
				</div>
			</div>
		@endforeach
		</div>
	</div>
</section>

@if(get_option('home_fixed_deposit_section', 1) == 1)
<section class="section">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-lg-7 text-center">
				<div class="section-title">
					<h2>{{ get_trans_option('home_fixed_deposit_heading') }}</h2>
					<div class="divider mx-auto my-4"></div>
					<p>{{ get_trans_option('home_fixed_deposit_content') }}</p>
				</div>
			</div>
		</div>

		<div class="row">
			@foreach($fdr_plans as $fdr_plan)
			<div class="col-lg-4">
				<div class="pricing-table mb-4">
					<div class="pricing-table-head">
						<h4 class="my-3">{{ $fdr_plan->name }}</h4>
						<h3 class="my-3">{{ $fdr_plan->interest_rate }}%</h3>
					</div>
					<div class="pricing-table-content">
						<table class="table">
							<tr>
								<td>{{ _lang('Duration') }}</td>
								<td>{{ $fdr_plan->duration.' '._dlang(ucwords($fdr_plan->duration_type)) }}</td>
							</tr>
							<tr>
								<td>{{ _lang('Interest Rate') }}</td>
								<td>{{ $fdr_plan->interest_rate.' %' }}</td>
							</tr>
							<tr>
								<td>{{ _lang('Minimum') }}</td>
								<td>{{ decimalPlace($fdr_plan->minimum_amount, currency()) }}</td>
							</tr>
							<tr>
								<td>{{ _lang('Maximum') }}</td>
								<td>{{ decimalPlace($fdr_plan->maximum_amount, currency()) }}</td>
							</tr>
						</table>
					</div>
					<div class="text-center mt-4">
						<a href="{{ route('fixed_deposits.apply') }}" class="btn">{{ _lang('Apply Now') }}</a>
					</div>
				</div>
			</div>
			@endforeach
		</div>
	</div>
</section>
@endif

@if(get_option('dps_section', 1) == 1)
<section class="section dps gray-bg">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-lg-7 text-center">
				<div class="section-title">
					<h2>{{ get_trans_option('home_dps_heading') }}</h2>
					<div class="divider mx-auto my-4"></div>
					<p>{{ get_trans_option('home_dps_content') }}</p>
				</div>
			</div>
		</div>

		<div class="row">
			@foreach($dps_plans as $dps_plan)
			<div class="col-lg-4">
				<div class="pricing-table mb-4">
					<div class="pricing-table-head">
						<h4 class="my-3">{{ $dps_plan->name }}</h4>
						<h3 class="my-3">{{ $dps_plan->interest_rate }}%</h3>
					</div>
					<div class="pricing-table-content">
						<table class="table">
							<tr>
								<td>{{ _lang('Currency') }}</td>
								<td>{{ $dps_plan->currency->name }}</td>
							</tr>
							<tr>
								<td>{{ _lang('Per Instalment') }}</td>
								<td>{{ decimalPlace($dps_plan->per_installment, currency($dps_plan->currency->name)) }}</td>
							</tr>
							<tr>
								<td>{{ _lang('Installment Interva') }}</td>
								<td>{{ _lang('Every').' '.$dps_plan->installment_interval }} {{ ucwords($dps_plan->interval_type) }}</td>
							</tr>
							<tr>
								<td>{{ _lang('Interest Rate') }}</td>
								<td>{{ $dps_plan->interest_rate }}</td>
							</tr>
							<tr>
								<td>{{ _lang('Total Installment') }}</td>
								<td>{{ $dps_plan->total_installment }}</td>
							</tr>
							<tr>
								<td>{{ _lang('Total Deposit') }}</td>
								<td>{{ decimalPlace($dps_plan->total_installment *  $dps_plan->per_installment, currency($dps_plan->currency->name)) }}</td>
							</tr>
							<tr>
								<td>{{ _lang('Matured Amount') }}</td>
								<td>{{ decimalPlace($dps_plan->final_amount, currency($dps_plan->currency->name)) }}</td>
							</tr>
						</table>
					</div>
					<div class="text-center mt-4">
						<a href="{{ route('dps_scheme.apply',$dps_plan->id) }}" class="btn">{{ _lang('Apply Now') }}</a>
					</div>
				</div>
			</div>
			@endforeach
		</div>
	</div>
</section>
@endif


@if(get_option('home_loan_section', 1) == 1)
<section class="section loan">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-lg-7 text-center">
				<div class="section-title">
					<h2>{{ get_trans_option('home_loan_heading') }}</h2>
					<div class="divider mx-auto my-4"></div>
					<p>{{ get_trans_option('home_loan_content') }}</p>
				</div>
			</div>
		</div>

		<div class="row">
			@foreach($loan_plans as $loan_plan)
			<div class="col-lg-4">
				<div class="pricing-table mb-4">
					<div class="pricing-table-head">
						<h4 class="my-3">{{ $loan_plan->name }}</h4>
						<h3 class="my-3">{{ $loan_plan->interest_rate.' %' }}</h3>
					</div>
					<div class="pricing-table-content">
						<table class="table">
							<tr>
								<td>{{ _lang('Term') }}</td>
								<td>
									{{ $loan_plan->term }}
									@if($loan_plan->term_period === '+1 month')
										{{ _lang('Month') }}
									@elseif($loan_plan->term_period === '+1 year')
										{{ _lang('Year') }}
									@elseif($loan_plan->term_period === '+1 day')
										{{ _lang('Day') }}
									@elseif($loan_plan->term_period === '+1 week')
										{{ _lang('Week') }}
									@endif
								</td>
							</tr>

							<tr>
								<td>{{ _lang('Interest Rate') }}</td>
								<td>{{ $loan_plan->interest_rate.' %' }}</td>
							</tr>

							<tr>
								<td>{{ _lang('Interest Type') }}</td>
								<td>{{ ucwords(str_replace("_"," ", $loan_plan->interest_type)) }}</td>
							</tr>

							<tr>
								<td>{{ _lang('Minimum') }}</td>
								<td>{{ decimalPlace($loan_plan->minimum_amount, currency()) }}</td>
							</tr>

							<tr>
								<td>{{ _lang('Maximum') }}</td>
								<td>{{ decimalPlace($loan_plan->maximum_amount, currency()) }}</td>
							</tr>
						</table>
					</div>
					<div class="text-center mt-4">
						<a href="{{ route('loans.apply_loan') }}" class="btn">{{ _lang('Apply Now') }}</a>
					</div>
				</div>
			</div>
			@endforeach

		</div>
	</div>
</section>
@endif

<section class="section testimonial-2">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-lg-7">
				<div class="section-title text-center">
					<h2>{{ get_trans_option('home_testimonial_heading') }}</h2>
					<div class="divider mx-auto my-4"></div>
					<p>{{ get_trans_option('home_testimonial_content') }}</p>
				</div>
			</div>
		</div>
	</div>

	<div class="container">
		<div class="row align-items-center">
			<div class="col-lg-12 testimonial-wrap-2">
				@foreach($testimonials as $testimonial)
				<div class="testimonial-block style-2 gray-bg">
					<i class="icofont-quote-right"></i>

					<div class="testimonial-thumb">
						<img src="{{ media_images($testimonial->image) }}" alt="{{ $testimonial->translation->name }}" class="img-fluid">
					</div>

					<div class="client-info">
						<h4>{{ $testimonial->translation->name }}</h4>
						<p>{{ $testimonial->translation->testimonial }}</p>
					</div>
				</div>
				@endforeach
			</div>
		</div>
	</div>
</section>
@endsection
