@extends('layouts.auth')

@section('content')
<div class="auth-container d-md-flex align-items-center">
    <div class="container">
        <div class="row">
         <div class="col-md-12 col-lg-10 offset-lg-1">
                <div class="bg-white p-2">
                    <div class="row no-gutters">
                        <div class="col-md-6">
                            <div class="card card-signin">

                                <div class="card-body">
                                    
                                    <img class="logo" src="{{ get_logo() }}">
                                        
                                    <h6 class="py-4">{{ _lang('Verify Your Email Address') }}</h6> 
                                    
                                    @if (session('resent'))
                                        <div class="alert alert-success" role="alert">
                                            {{ _lang('A fresh verification link has been sent to your email address.') }}
                                        </div>
                                    @endif

                                    {{ _lang('Before proceeding, please check your email for a verification link.') }}
                                    {{ _lang('If you did not receive the email') }},
                                    <form class="d-inline" method="POST" action="{{ route('verification.resend') }}">
                                        @csrf
                                        <button type="submit" class="btn btn-link p-0 m-0 align-baseline mt-4">{{ _lang('Click here to request another') }}</button>.
                                    </form>
                                    
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 d-none d-md-block">
                            <div id="auth-bg" class="d-flex align-items-center justify-content-center">
                                <div>
                                    <p class="mb-1 font-weight-light">{{ _lang('WELCOME TO') }}</p>
                                    <h2 class="font-weight-bold">{{ get_option('site_title', config('app.name')) }}</h2>

                                    <div class="divider"></div>

                                    <h6>{{ _lang('Verify Your Email Address') }}</h6> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
